/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.utilization.legacy.v1;

import com.nuix.automate.utils.general.FrequentLogUtils;
import com.nuix.automate.utils.general.InternationalizationUtils;
import com.nuix.automate.utils.general.UidUtils;
import com.nuix.automate.utils.licence.services.Product;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.utilization.Client;
import com.nuix.automate.utils.utilization.Engine;
import com.nuix.automate.utils.utilization.Job;
import com.nuix.automate.utils.utilization.Matter;
import com.nuix.automate.utils.utilization.MimeTypeVolume;
import com.nuix.automate.utils.utilization.NuixCase;
import com.nuix.automate.utils.utilization.Operation;
import com.nuix.automate.utils.utilization.OperationType;
import com.nuix.automate.utils.utilization.Priority;
import com.nuix.automate.utils.utilization.ResourcePool;
import com.nuix.automate.utils.utilization.Server;
import com.nuix.automate.utils.utilization.Session;
import com.nuix.automate.utils.utilization.User;
import com.nuix.automate.utils.utilization.UtilizationRecords;
import com.nuix.automate.utils.utilization.legacy.v1.BatchMimeTypesUtilizationModel;
import com.nuix.automate.utils.utilization.legacy.v1.BatchUtilizationModel;
import com.nuix.automate.utils.utilization.legacy.v1.CaseUtilizationModel;
import com.nuix.automate.utils.utilization.legacy.v1.ClientUtilizationModel;
import com.nuix.automate.utils.utilization.legacy.v1.EngineUtilizationModel;
import com.nuix.automate.utils.utilization.legacy.v1.JobUtilizationModel;
import com.nuix.automate.utils.utilization.legacy.v1.MatterUtilizationModel;
import com.nuix.automate.utils.utilization.legacy.v1.ResourcePoolUtilizationModel;
import com.nuix.automate.utils.utilization.legacy.v1.ServerUtilizationModel;
import com.nuix.automate.utils.utilization.legacy.v1.UtilizationRecordsModel;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.TimeZone;

public class UtilizationMigrator {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(UtilizationMigrator.class);
    private static transient InternationalizationUtils iu = InternationalizationUtils.getInstance("WorkflowText");

    public static UtilizationRecords migrateFromV1(UtilizationRecordsModel utilizationRecordsModel, String licenseId) {
        UtilizationRecords utilizationRecords = new UtilizationRecords();
        LOGGER.info("Migrating v1 utilization");
        LOGGER.info("Migrating v1 utilization - Cases");
        HashMap<String, NuixCase> newCases = new HashMap<String, NuixCase>();
        List<CaseUtilizationModel> cases = utilizationRecordsModel.getCases();
        boolean caseId = false;
        HashMap<String, NuixCase> nuixCaseMap = new HashMap<String, NuixCase>();
        for (CaseUtilizationModel caseUtilizationModel : cases) {
            NuixCase nuixCase = new NuixCase();
            nuixCase.setNuixCaseName(caseUtilizationModel.getCaseName());
            nuixCase.setNuixCaseLocation(caseUtilizationModel.getCaseLocation());
            nuixCase.setNuixCaseId(caseUtilizationModel.getCaseId());
            newCases.put(nuixCase.getNuixCaseId(), nuixCase);
            nuixCaseMap.put(nuixCase.getNuixCaseId(), nuixCase);
        }
        FrequentLogUtils.resetLastTimestamp();
        FrequentLogUtils.info("Migrating " + newCases.size() + " new Cases");
        utilizationRecords.setNuixCases(new HashSet<NuixCase>());
        utilizationRecords.getNuixCases().addAll(newCases.values());
        FrequentLogUtils.resetLastTimestamp();
        LOGGER.info("Migrating v1 utilization - Servers");
        utilizationRecords.setServers(new HashSet<Server>());
        List<ServerUtilizationModel> servers = utilizationRecordsModel.getServers();
        for (ServerUtilizationModel serverV1 : servers) {
            Server server = new Server();
            server.setServerName(serverV1.getServerName());
            server.setServerId(serverV1.getServerId());
            utilizationRecords.getServers().add(server);
        }
        LOGGER.info("Migrated v1 utilization - " + servers.size() + " Servers");
        HashMap<String, String> hashMap = new HashMap<String, String>();
        HashMap<String, Long> batchIdsVolume = new HashMap<String, Long>();
        LOGGER.info("Migrating v1 utilization - Batches");
        HashMap<String, Object> jobsBatchesV1 = new HashMap<String, Object>();
        List<BatchUtilizationModel> batchesV1 = utilizationRecordsModel.getBatches();
        for (BatchUtilizationModel batchV1 : batchesV1) {
            batchIdsVolume.put(batchV1.getBatchId(), 0L);
            Object jobBatchesV1 = (ArrayList<BatchUtilizationModel>)jobsBatchesV1.get(batchV1.getJobId());
            if (jobBatchesV1 == null) {
                jobBatchesV1 = new ArrayList<BatchUtilizationModel>();
                jobsBatchesV1.put(batchV1.getJobId(), jobBatchesV1);
            }
            jobBatchesV1.add(batchV1);
        }
        LOGGER.info("Migrated v1 utilization - " + batchesV1.size() + " Batches");
        HashMap<String, String> batchIdsToOperationIds = new HashMap<String, String>();
        LOGGER.info("Migrating v1 utilization - Batch Infos 1/2");
        List<BatchMimeTypesUtilizationModel> batchesInfo = utilizationRecordsModel.getBatchesInfo();
        for (BatchMimeTypesUtilizationModel batchInfoV1 : batchesInfo) {
            Long batchIdVolume = (Long)batchIdsVolume.get(batchInfoV1.getBatchId());
            if (batchIdVolume == null) {
                batchIdsVolume.put(batchInfoV1.getBatchId(), batchInfoV1.getAuditedSize());
                continue;
            }
            batchIdsVolume.put(batchInfoV1.getBatchId(), batchIdVolume + batchInfoV1.getAuditedSize());
        }
        LOGGER.info("Migrated v1 utilization - " + batchesInfo.size() + " Batch Info 1/2");
        utilizationRecords.setUsers(new HashSet<User>());
        ArrayList<Job> jobsList = new ArrayList<Job>();
        HashMap<String, Session> sessions = new HashMap<String, Session>();
        ArrayList<Operation> operations = new ArrayList<Operation>();
        LOGGER.info("Migrating v1 utilization - Jobs");
        List<JobUtilizationModel> jobs = utilizationRecordsModel.getJobs();
        int jobId = 0;
        for (JobUtilizationModel jobUtilizationModel : jobs) {
            FrequentLogUtils.info("Scanning Job " + ++jobId + " of " + jobs.size());
            if (jobUtilizationModel.getEngineId() != null) {
                hashMap.put(jobUtilizationModel.getEngineId(), jobUtilizationModel.getServerId());
            }
            User user = new User();
            user.setUserId(User.getIdFromName(jobUtilizationModel.getJobSubmittedBy(), ""));
            user.setUserName(jobUtilizationModel.getJobSubmittedBy().toLowerCase());
            user.setUserTimeZone(TimeZone.getDefault().getID());
            utilizationRecords.getUsers().add(user);
            Job job = new Job();
            int priority = 2;
            if (jobUtilizationModel.getJobPriority() != null) {
                priority = jobUtilizationModel.getJobPriority().getInt();
            }
            job.setJobPriority(Priority.fromInteger(priority));
            job.setJobSubmittedByUserId(User.getIdFromName(jobUtilizationModel.getJobSubmittedBy(), ""));
            job.setJobSubmissionEpoch(jobUtilizationModel.getJobSubmittedEpoch());
            job.setJobName(jobUtilizationModel.getJobName());
            job.setWorkflowId(jobUtilizationModel.getLibraryWorkflowId());
            job.setEngineId(jobUtilizationModel.getEngineId());
            job.setResourcePoolId(jobUtilizationModel.getResourcePoolId());
            job.setMatterId(jobUtilizationModel.getMatterId());
            job.setJobHasErrors(jobUtilizationModel.getJobHasErrors());
            job.setJobHasSoftErrors(false);
            job.setJobHasWarnings(jobUtilizationModel.getJobHasWarnings());
            job.setJobPercentageComplete(jobUtilizationModel.getJobPercentageComplete());
            job.setJobExecutionState(jobUtilizationModel.getJobExecutionState());
            job.setJobEndEpoch(jobUtilizationModel.getJobEndEpoch());
            job.setJobStartEpoch(jobUtilizationModel.getJobStartEpoch());
            job.setJobId(jobUtilizationModel.getJobId());
            jobsList.add(job);
            long volumeLoaded = 0L;
            long volumeExported = 0L;
            List list = (List)jobsBatchesV1.get(job.getJobId());
            if (list == null) continue;
            list.sort(Comparator.comparing(BatchUtilizationModel::getBatchStartEpoch));
            Session session = null;
            int operationId = 1;
            int lastWorkerCount = 1;
            for (BatchUtilizationModel batchV1 : list) {
                if (batchV1.getLicenseWorkersCount() != null) {
                    lastWorkerCount = batchV1.getLicenseWorkersCount();
                }
                if (session == null || session.getSessionWorkers() != lastWorkerCount || session.getNuixLicenseType() != null && !session.getNuixLicenseType().equals(batchV1.getLicenseType()) || batchV1.getLicenseType() != null && !batchV1.getLicenseType().equals(session.getNuixLicenseType())) {
                    session = new Session();
                    session.setSessionStartEpoch(batchV1.getBatchStartEpoch());
                    session.setProductVersion(jobUtilizationModel.getJobEngineServerVersion());
                    session.setProductName(Product.ENGINE.name());
                    session.setNuixVersion(batchV1.getNuixVersion());
                    session.setSessionWorkers(lastWorkerCount);
                    session.setNuixLicenseType(batchV1.getLicenseType());
                    session.setJobId(job.getJobId());
                    session.setSessionId(UidUtils.getRandom());
                    sessions.put(session.getSessionId(), session);
                }
                Operation operation = new Operation();
                operation.setSessionId(session.getSessionId());
                operation.setOperationExecutionPosition(++operationId);
                operation.setOperationWorkflowPosition(operationId);
                operation.setOperationId(session.getSessionId() + "-" + operationId);
                operation.setOperationName("Unknown");
                operation.setOperationStartEpoch(batchV1.getBatchStartEpoch());
                operation.setOperationEndEpoch(batchV1.getBatchEndEpoch());
                if (batchV1.getBatchNextEventEpoch() != null) {
                    operation.setOperationNextEventEpoch(batchV1.getBatchNextEventEpoch());
                } else {
                    operation.setOperationNextEventEpoch(batchV1.getBatchEndEpoch() + 1L);
                }
                OperationType operationType = OperationType.OTHER_NON_WORKER;
                batchIdsToOperationIds.put(batchV1.getBatchId(), operation.getOperationId());
                switch (batchV1.getBatchType()) {
                    case LOAD: {
                        operationType = OperationType.LOAD;
                        operation.setOperationName(iu.getString("AddEvidenceOperation.Property.Name"));
                        session.setVolumeLoaded(session.getVolumeLoaded() + (Long)batchIdsVolume.get(batchV1.getBatchId()));
                        break;
                    }
                    case RELOAD: {
                        operationType = OperationType.LOAD;
                        operation.setOperationName(iu.getString("ReloadItemsOperation.Property.Name"));
                        session.setVolumeLoaded(session.getVolumeLoaded() + (Long)batchIdsVolume.get(batchV1.getBatchId()));
                        break;
                    }
                    case LEGAL_EXPORT: {
                        operationType = OperationType.LEGAL_EXPORT;
                        operation.setOperationName(iu.getString("LegalExportOperation.Property.Name"));
                        session.setVolumeExported(session.getVolumeExported() + (Long)batchIdsVolume.get(batchV1.getBatchId()));
                        break;
                    }
                    case DISCOVER_EXPORT: {
                        operationType = OperationType.LEGAL_EXPORT;
                        operation.setOperationName(iu.getString("PromoteToDiscoverOperation.Property.Name"));
                        session.setVolumeExported(session.getVolumeExported() + (Long)batchIdsVolume.get(batchV1.getBatchId()));
                        break;
                    }
                    case RELATIVITY_EXPORT: {
                        operationType = OperationType.LEGAL_EXPORT;
                        operation.setOperationName(iu.getString("LegalExportOperation.Property.Name"));
                        session.setVolumeExported(session.getVolumeExported() + (Long)batchIdsVolume.get(batchV1.getBatchId()));
                        break;
                    }
                    case NATIVE_EXPORT: {
                        operationType = OperationType.NATIVE_EXPORT;
                        operation.setOperationName(iu.getString("ExportItemsOperation.Property.Name"));
                        session.setVolumeExported(session.getVolumeExported() + (Long)batchIdsVolume.get(batchV1.getBatchId()));
                        break;
                    }
                    case OTHER_EXPORT: {
                        operationType = OperationType.OTHER_EXPORT;
                        operation.setOperationName("Unknown");
                        session.setVolumeExported(session.getVolumeExported() + (Long)batchIdsVolume.get(batchV1.getBatchId()));
                        break;
                    }
                    case OCR: {
                        operationType = OperationType.OCR;
                        operation.setOperationName(iu.getString("OcrOperation.Property.Name"));
                        break;
                    }
                    case IMAGE: {
                        operationType = OperationType.IMAGE;
                        operation.setOperationName(iu.getString("GeneratePrintedImagesOperation.Property.Name"));
                        break;
                    }
                    case OTHER_NON_WORKER: {
                        operationType = OperationType.OTHER_NON_WORKER;
                        operation.setOperationName("Unknown");
                    }
                }
                session.setSessionEndEpoch(batchV1.getBatchEndEpoch());
                session.setLicenseId(licenseId);
                operation.setOperationType(operationType);
                operation.setNuixCaseId(batchV1.getCaseId());
                NuixCase nuixCase = (NuixCase)nuixCaseMap.get(batchV1.getCaseId());
                if (nuixCase != null) {
                    if (nuixCase.getNuixCaseCreationEpoch() == 0L || nuixCase.getNuixCaseCreationEpoch() > batchV1.getBatchStartEpoch()) {
                        nuixCase.setNuixCaseCreationEpoch(batchV1.getBatchStartEpoch());
                        nuixCase.setNuixCaseVersion(batchV1.getNuixVersion());
                    }
                    if (!(batchV1.getBatchType().equals((Object)BatchUtilizationModel.BatchType.OTHER_NON_WORKER) || nuixCase.getNuixCaseLastModifiedEpoch() != 0L && nuixCase.getNuixCaseLastModifiedEpoch() >= batchV1.getBatchEndEpoch())) {
                        nuixCase.setNuixCaseLastModifiedEpoch(batchV1.getBatchEndEpoch());
                    }
                }
                ++operationId;
                operations.add(operation);
            }
        }
        LOGGER.info("Scanned v1 utilization - " + jobs.size() + " Jobs");
        HashMap<String, Job> newJobs = new HashMap<String, Job>();
        for (Job job : jobsList) {
            newJobs.put(job.getJobId(), job);
        }
        utilizationRecords.setJobs(new HashSet<Job>());
        FrequentLogUtils.resetLastTimestamp();
        FrequentLogUtils.info("Migrating " + newJobs.size() + " new Jobs");
        utilizationRecords.getJobs().addAll(newJobs.values());
        FrequentLogUtils.resetLastTimestamp();
        HashMap<String, Operation> hashMap2 = new HashMap<String, Operation>();
        utilizationRecords.setOperations(new HashSet<Operation>());
        LOGGER.info("Migrating v1 utilization - Operations");
        for (Operation operation : operations) {
            hashMap2.put(operation.getOperationId(), operation);
        }
        FrequentLogUtils.resetLastTimestamp();
        FrequentLogUtils.info("Migrating " + hashMap2.size() + " new Operations");
        utilizationRecords.getOperations().addAll(hashMap2.values());
        FrequentLogUtils.resetLastTimestamp();
        HashMap<String, Session> hashMap3 = new HashMap<String, Session>();
        LOGGER.info("Migrating v1 utilization - Sessions");
        for (String sessionId : sessions.keySet()) {
            hashMap3.put(sessionId, (Session)sessions.get(sessionId));
        }
        FrequentLogUtils.resetLastTimestamp();
        FrequentLogUtils.info("Migrating " + hashMap3.size() + " new sessions");
        utilizationRecords.setSessions(new HashSet<Session>());
        utilizationRecords.getSessions().addAll(hashMap3.values());
        FrequentLogUtils.resetLastTimestamp();
        LOGGER.info("Migrating v1 utilization - Batch Infos 2/2");
        HashMap<String, Object> hashMap4 = new HashMap<String, Object>();
        List<BatchMimeTypesUtilizationModel> batches = utilizationRecordsModel.getBatchesInfo();
        int batchId = 0;
        for (BatchMimeTypesUtilizationModel batchInfoV1 : batches) {
            FrequentLogUtils.info("Scanning Batch Info " + batchId + " of " + batches.size());
            Object mimeTypeVolume = new MimeTypeVolume();
            String string = (String)batchIdsToOperationIds.get(batchInfoV1.getBatchId());
            ((MimeTypeVolume)mimeTypeVolume).setOperationId(string);
            String mimeTypeId = batchInfoV1.getMimeTypeId();
            ((MimeTypeVolume)mimeTypeVolume).setMimeTypeId(mimeTypeId);
            hashMap4.put(string + mimeTypeId, mimeTypeVolume);
            ((MimeTypeVolume)mimeTypeVolume).setAuditedCount(batchInfoV1.getAuditedCount());
            ((MimeTypeVolume)mimeTypeVolume).setAuditedSize(batchInfoV1.getAuditedSize());
            ((MimeTypeVolume)mimeTypeVolume).setItemsCount(batchInfoV1.getItemsCount());
            ((MimeTypeVolume)mimeTypeVolume).setPagesCount(batchInfoV1.getPagesCount());
            ((MimeTypeVolume)mimeTypeVolume).setPhysicalCount(batchInfoV1.getPhysicalCount());
            ((MimeTypeVolume)mimeTypeVolume).setPhysicalCount(batchInfoV1.getPhysicalCount());
        }
        FrequentLogUtils.resetLastTimestamp();
        FrequentLogUtils.info("Migrating " + hashMap4.size() + " new Batch Infos");
        HashMap<String, Operation> operationMap = new HashMap<String, Operation>();
        for (Operation operation : utilizationRecords.getOperations()) {
            operationMap.put(operation.getOperationId(), operation);
        }
        for (Object mimeTypeVolume : hashMap4.values()) {
            Operation operation = (Operation)operationMap.get(((MimeTypeVolume)mimeTypeVolume).getOperationId());
            if (operation.getMimeTypeVolumes() == null) {
                operation.setMimeTypeVolumes(new ArrayList<MimeTypeVolume>());
            }
            operation.getMimeTypeVolumes().add((MimeTypeVolume)mimeTypeVolume);
        }
        FrequentLogUtils.resetLastTimestamp();
        utilizationRecords.setEngines(new HashSet<Engine>());
        List<EngineUtilizationModel> engines = utilizationRecordsModel.getEngines();
        if (engines != null) {
            for (EngineUtilizationModel engineUtilizationModel : engines) {
                Engine engine = new Engine();
                engine.setEngineId(engineUtilizationModel.getEngineId());
                engine.setEngineName(engineUtilizationModel.getEngineName());
                engine.setServerId((String)hashMap.get(engine.getEngineId()));
                utilizationRecords.getEngines().add(engine);
            }
            LOGGER.info("Migrated v1 utilization - " + engines.size() + " Engines");
        }
        utilizationRecords.setResourcePools(new HashSet<ResourcePool>());
        List<ResourcePoolUtilizationModel> resourcePools = utilizationRecordsModel.getResourcePoolUtilizationModel();
        for (ResourcePoolUtilizationModel resourcePoolV1 : resourcePools) {
            ResourcePool resourcePool = new ResourcePool();
            resourcePool.setResourcePoolId(resourcePoolV1.getResourcePoolId());
            resourcePool.setResourcePoolName(resourcePoolV1.getResourcePoolName());
            utilizationRecords.getResourcePools().add(resourcePool);
        }
        LOGGER.info("Migrated v1 utilization - " + resourcePools.size() + " Resource Pools");
        HashMap<String, Matter> hashMap5 = new HashMap<String, Matter>();
        List<MatterUtilizationModel> matters = utilizationRecordsModel.getMatters();
        for (MatterUtilizationModel matterV1 : matters) {
            Matter matter = new Matter();
            matter.setMatterId(matterV1.getMatterId());
            if (matterV1.getMatterIsActive() != null) {
                matter.setMatterIsActive(matterV1.getMatterIsActive());
            }
            matter.setMatterName(matterV1.getMatterName());
            matter.setClientId(matterV1.getClientId());
            hashMap5.put(matter.getMatterId(), matter);
        }
        FrequentLogUtils.resetLastTimestamp();
        FrequentLogUtils.info("Migrating " + hashMap5.size() + " new Matters");
        utilizationRecords.setMatters(new HashSet<Matter>());
        utilizationRecords.getMatters().addAll(hashMap5.values());
        FrequentLogUtils.resetLastTimestamp();
        HashMap<String, Client> newClients = new HashMap<String, Client>();
        List<ClientUtilizationModel> clients = utilizationRecordsModel.getClients();
        for (ClientUtilizationModel clientV1 : clients) {
            Client client = new Client();
            if (clientV1.getClientIsActive() != null) {
                client.setClientIsActive(clientV1.getClientIsActive());
            }
            client.setClientName(clientV1.getClientName());
            client.setClientId(clientV1.getClientId());
            newClients.put(client.getClientId(), client);
        }
        FrequentLogUtils.resetLastTimestamp();
        FrequentLogUtils.info("Migrating " + newClients.size() + " new Clients");
        utilizationRecords.setClients(new HashSet<Client>());
        utilizationRecords.getClients().addAll(newClients.values());
        FrequentLogUtils.resetLastTimestamp();
        return utilizationRecords;
    }
}

