/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.workflow;

import com.nuix.automate.utils.workflow.Parameter;
import com.nuix.automate.utils.workflow.ScriptLanguage;
import java.io.Serializable;
import java.util.LinkedHashSet;
import java.util.Set;

public class ScriptedParameterOptions
implements Serializable,
Cloneable {
    private String scriptCode;
    private ScriptLanguage scriptLanguage;
    private Set<String> dependantParameters;
    private boolean useLibraryFile;
    private String libraryFileId;

    public ScriptedParameterOptions() {
        this.scriptLanguage = ScriptLanguage.PYTHON;
        this.scriptCode = "";
        this.dependantParameters = new LinkedHashSet<String>();
        this.useLibraryFile = false;
        this.libraryFileId = "";
    }

    public ScriptedParameterOptions(Parameter parameter) {
        if (parameter == null) {
            this.scriptCode = "";
            this.scriptLanguage = ScriptLanguage.PYTHON;
            this.dependantParameters = new LinkedHashSet<String>();
            this.useLibraryFile = false;
            this.libraryFileId = "";
        } else {
            this.scriptCode = parameter.getScriptCode();
            this.scriptLanguage = parameter.getScriptLanguage();
            this.dependantParameters = parameter.getDependantParameters();
            this.useLibraryFile = parameter.isUseLibraryFile();
            this.libraryFileId = parameter.getLibraryFileId();
        }
    }

    public ScriptedParameterOptions clone() {
        try {
            ScriptedParameterOptions clone = (ScriptedParameterOptions)super.clone();
            if (this.dependantParameters != null) {
                clone.dependantParameters = new LinkedHashSet<String>(this.dependantParameters);
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public String getScriptCode() {
        return this.scriptCode;
    }

    public void setScriptCode(String scriptCode) {
        this.scriptCode = scriptCode;
    }

    public ScriptLanguage getScriptLanguage() {
        return this.scriptLanguage;
    }

    public void setScriptLanguage(ScriptLanguage scriptLanguage) {
        this.scriptLanguage = scriptLanguage;
    }

    public Set<String> getDependantParameters() {
        return this.dependantParameters;
    }

    public void setDependantParameters(Set<String> dependantParameters) {
        this.dependantParameters = dependantParameters;
    }

    public boolean isUseLibraryFile() {
        return this.useLibraryFile;
    }

    public void setUseLibraryFile(boolean useLibraryFile) {
        this.useLibraryFile = useLibraryFile;
    }

    public String getLibraryFileId() {
        return this.libraryFileId;
    }

    public void setLibraryFileId(String libraryFileId) {
        this.libraryFileId = libraryFileId;
    }

    public String toString() {
        if (this.scriptLanguage != null) {
            return this.scriptLanguage.toLocalizedString() + " Script";
        }
        return "";
    }
}

