/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.workflow;

import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.internal.formbuilder.ComparisonOperator;
import com.nuix.automate.utils.models.internal.formbuilder.FieldComponentType;
import com.nuix.automate.utils.models.internal.formbuilder.FormField;
import com.nuix.automate.utils.models.internal.formbuilder.OnField;
import com.nuix.automate.utils.workflow.Parameter;
import com.nuix.automate.utils.workflow.ParameterType;
import com.nuix.automate.utils.workflow.ParameterValueMatchBy;

public class StaticParameter
extends Parameter {
    private static final transient LoggerWrapper LOGGER = LogManagerUtils.getLogger(StaticParameter.class);
    @FormField(componentType=FieldComponentType.PARAMETER_INPUT, order=2, required=false, enableOn={@OnField(name="parameterType", comparisonOperator=ComparisonOperator.NOT_EQUAL, value={"TEXT_MASKED", "TEXT_PROTECTED"})})
    private String value;

    public StaticParameter() {
        this.name = "";
        this.value = "";
        this.friendlyName = null;
        this.description = "";
        this.regex = "";
    }

    public StaticParameter(String name, String value) {
        this.name = name;
        this.value = value;
        this.description = "";
        this.regex = "";
        this.setFriendlyNameFromName();
    }

    public StaticParameter(String name, String value, String description) {
        this.name = name;
        this.value = value;
        this.description = description;
        this.regex = "";
        this.setFriendlyNameFromName();
    }

    public StaticParameter(com.nuix.automate.utils.models.api.job.Parameter parameter) {
        this.name = parameter.getName();
        this.parameterType = parameter.getParameterType();
        this.value = parameter.getValue();
        this.friendlyName = parameter.getFriendlyName();
        this.description = parameter.getDescription();
        this.regex = parameter.getRegex();
        this.allowedValuesMatchBy = parameter.getAllowedValuesMatchBy();
        this.allowedValues = parameter.getAllowedValues();
        this.userDisplayableValue = parameter.getUserDisplayableValue();
        this.displayCondition = parameter.getDisplayCondition().clone();
        this.relativityCondition = parameter.getRelativityCondition().clone();
        this.dependantParameters = parameter.getDependantParameters();
        this.scriptLanguage = parameter.getScriptLanguage();
        this.scriptCode = parameter.getScriptCode();
    }

    public StaticParameter(String name, String value, String description, String regex) {
        this.name = name;
        this.value = value;
        this.description = description;
        this.regex = regex;
        this.setFriendlyNameFromName();
    }

    @Override
    public String getMaskedValue() {
        String protectedValue = this.getValue();
        if (this.getEffectiveParameterType().equals((Object)ParameterType.TEXT_PROTECTED) || this.getEffectiveParameterType().equals((Object)ParameterType.TEXT_MASKED) && protectedValue.length() > 0) {
            return MASKED_VALUE;
        }
        return protectedValue;
    }

    @Override
    public String getValue() {
        String protectedValue = this.getProtectedValue();
        if (this.getEffectiveParameterType().equals((Object)ParameterType.TEXT_PROTECTED) && protectedValue != null && protectedValue.length() > 0) {
            return MASKED_VALUE;
        }
        return protectedValue;
    }

    public void setValue(String value) {
        this.value = value;
    }

    @Override
    public String getProtectedValue() {
        return this.value;
    }

    public String toString() {
        String allowedValuesMatchBy = null;
        if (this.allowedValues != null && this.allowedValues.size() > 0) {
            allowedValuesMatchBy = (this.allowedValuesMatchBy == null ? ParameterValueMatchBy.SYSTEM_OR_USER_PRINTABLE_VALUE : this.allowedValuesMatchBy).toString();
        }
        return this.name + (this.parameterType != null && this.parameterType == ParameterType.SCRIPTED ? "; Scripted Parameter" : "") + (this.description != null && this.description.length() > 0 ? "; Description: '" + this.description + '\'' : "") + (this.regex != null && this.regex.length() > 0 ? "; Regex: '" + this.regex + '\'' : "") + (this.friendlyName != null && this.friendlyName.length() > 0 ? "; Friendly Name: '" + this.friendlyName + '\'' : "") + (this.min != null && this.min.length() > 0 ? "; Min: '" + this.min + '\'' : "") + (this.max != null && this.max.length() > 0 ? "; Max: '" + this.max + '\'' : "") + (!this.isEffectiveTypeMaskedOrProtected() && this.value != null && this.value.length() > 0 ? "; Value: '" + this.value + '\'' : "") + (allowedValuesMatchBy != null ? "; Allowed Values Match By: " + allowedValuesMatchBy : "") + (this.allowedValues != null && this.allowedValues.size() > 0 ? "; Allowed Values: [" + String.join((CharSequence)", ", this.allowedValues) + ']' : "") + (this.relativityCondition != null && this.relativityCondition.toString().length() > 0 ? "; Values Filter: '" + this.relativityCondition.toString() + '\'' : "") + (this.userDisplayableValue != null && this.userDisplayableValue.length() > 0 ? "; User Displayable Value: '" + this.userDisplayableValue + '\'' : "") + (this.displayCondition != null && this.displayCondition.toLocalizedString().length() > 0 ? "; Display if: '" + this.displayCondition.toLocalizedString() + '\'' : "");
    }
}

