$inkscapeExecutables = @("C:\Program Files\Inkscape\bin\inkscape", "/Applications/Inkscape.app/Contents/MacOS/inkscape")
$inkscapeExecutable = $null

foreach ($candidate in $inkscapeExecutables) {
    # Commands to execute for each item in the collection
    if ((Get-item -Path "$candidate" -ErrorAction Ignore)){
        Write-Host "Found Inkscape at $candidate"
        $inkscapeExecutable = $candidate
    }
}

if (!$inkscapeExecutable){
    $locations = [system.String]::Join(", ", $inkscapeExecutables)
    Write-Error "Cannot find Inkscape at one of $locations"
}

Get-ChildItem -Path .\ -Filter *.svg  -Name | ForEach-Object {
    $iconName = [System.IO.Path]::GetFileNameWithoutExtension($_)
    $pngFileName = $iconName+".png"
    $svgFileName = $iconName+".svg"
    
    if (!(Get-item -Path ".\$pngFileName" -ErrorAction Ignore)){
        Write-Host "Converting icon $iconName"
        
        & $inkscapeExecutable -h 256 $svgFileName -o $pngFileName
    }

}