import traceback
import sys
reload(sys)
sys.setdefaultencoding('utf8')

class DateFilterType:
	NONE, AFTER, BEFORE, BETWEEN, NOT_BETWEEN = range(5)

class MimeTypeFilterType:
	NONE, MATCH, NO_MATCH = range(3)

class DateFilterScope:
	TOP_LEVEL_COMMUNICATION, LOOSE_FILES, TOP_LEVEL_COMMUNICATION_AND_LOOSE_FILES = range(3)


print '### Worker-side script initializing'
from org.joda import time as joda
beforeDate = joda.DateTime('__DATE_BEFORE__')
afterDate = joda.DateTime('__DATE_AFTER__')
dateFilterType = DateFilterType.__DATE_FILTER_TYPE__
dateFilterScope = DateFilterScope.__DATE_FILTER_SCOPE__
mimeTypeFilterType = MimeTypeFilterType.__MIME_TYPE_FILTER_TYPE__
mimeTypeFilters = {}

__INIT_MIME_TYPE_FILTER__

print '### Worker-side script initialized'
print '### DateFilterType '+str(dateFilterType)
print '### DateFilterScope '+str(dateFilterScope)
print '### Before date '+str(beforeDate)
print '### After date '+str(afterDate)
print '#'
print '### MimeTypeFilterType '+str(mimeTypeFilterType)
for mimeTypeFilter in mimeTypeFilters:
	print '### MimeType: '+mimeTypeFilter+'\tName: '+str(mimeTypeFilters[mimeTypeFilter])

verboseNotProcessed = True
verbose = False
debug = False

def applyDateTimeFilter(workerItem):
	# No Filter
	if dateFilterType == DateFilterType.NONE:
		return True

	sourceItem = workerItem.getSourceItem()
	communicationItem = sourceItem.getCommunication()

	# Item is not a communication, no filtering will be applied
	if sourceItem.getCommunication() is None and dateFilterScope == DateFilterScope.TOP_LEVEL_COMMUNICATION:
		return True

	# Determine if item is loose file
	isLooseFile = True
	currentItem = True
	allowedTypes = ['filesystem/directory', 'application/vnd.nuix-evidence']
	for pathItem in reversed(sourceItem.getPath()):
		if currentItem:
			currentItem = False
			if pathItem.getType().getName() in allowedTypes:
				isLooseFile = False
				break
			continue
		type = pathItem.getType().getName()
		if type not in allowedTypes:
			isLooseFile = False
			break

	excludeFromLooseFilter = False
	if dateFilterScope != DateFilterScope.TOP_LEVEL_COMMUNICATION:
		# Item is not loose, no filtering will be applied
		if not isLooseFile:
			if dateFilterScope == DateFilterScope.LOOSE_FILES:
				return True
			else:
				excludeFromLooseFilter = True

	excludeFromCommunicationFilter = False
	if dateFilterScope != DateFilterScope.LOOSE_FILES:
		# Item is not top-level, no filtering will be applied
		if not sourceItem.isTopLevel() and sourceItem.getCommunication() is not None:
			if dateFilterScope == DateFilterScope.TOP_LEVEL_COMMUNICATION:
				return True
			else:
				excludeFromCommunicationFilter = True


	if excludeFromLooseFilter and excludeFromCommunicationFilter:
		return True

	filterDate = None
	if communicationItem is not None:
		filterDate = communicationItem.getDateTime()
	else:
		filterDate = sourceItem.getDate()

	# Item does not have a communication date
	if filterDate is None and sourceItem.getCommunication is not None:
		return
	process=False

	# Before Filter
	if dateFilterType == DateFilterType.BEFORE:
		if filterDate.isBefore(beforeDate):
			process=True

	# After Filter
	if dateFilterType == DateFilterType.AFTER:
		if filterDate.isAfter(afterDate):
			process=True

	# Between Filter
	if dateFilterType == DateFilterType.BETWEEN:
		if filterDate.isAfter(afterDate) and filterDate.isBefore(beforeDate):
			process=True

	# Not between Filter
	if dateFilterType == DateFilterType.NOT_BETWEEN:
		if (filterDate.isBefore(afterDate)) or (filterDate.isAfter(beforeDate)):
			process=True

	return process


def applyMimeTypeFilter(workerItem):
	# No Filter
	if mimeTypeFilterType == MimeTypeFilterType.NONE:
		return True

	sourceItem = workerItem.getSourceItem()

	# For each item  in the path
	for pathItem in sourceItem.getPath():
		pathItemType = pathItem.getType().getName()

		# If path is in user supplied list
		if pathItemType in mimeTypeFilters:

			# Match the names of the items
			nameMatch = (pathItem.getName() in mimeTypeFilters[pathItemType]) or ('*' in mimeTypeFilters[pathItemType])

			# Compare match result vs. filter match
			if nameMatch and (mimeTypeFilterType == MimeTypeFilterType.MATCH):
				return True
			if (not nameMatch) and (mimeTypeFilterType == MimeTypeFilterType.NO_MATCH):
				return True

			# Name match different than filter match type
			return False
	return True

def nuixWorkerItemCallback(workerItem):
	# Determine if item passes dateTimeFilter
	dateTimeFilterInclusion = True
	try:
		dateTimeFilterInclusion = applyDateTimeFilter(workerItem)
	except:
		print("Unexpected error in applyDateTimeFilter:", traceback.format_exc())
		workerItem.addCustomMetadata("Rampiva DateTime filter error",traceback.format_exc(),"text","user")

	mimeTypeFilterInclusion = True
	if (dateTimeFilterInclusion):
		try:
			mimeTypeFilterInclusion = applyMimeTypeFilter(workerItem)
		except:
			print("Unexpected error in mimeTypeFilterInclusion:", traceback.format_exc())
			workerItem.addCustomMetadata("Rampiva MimeType filter error",traceback.format_exc(),"text","user")

	process = dateTimeFilterInclusion and mimeTypeFilterInclusion

	if verbose or (not process and verboseNotProcessed):
		sourceItem = workerItem.getSourceItem()
		print '### Worker-side filter:\t'+sourceItem.getName()+'\t'+sourceItem.getKind().getName()+'\tDateFilter Include: '+str(dateTimeFilterInclusion)+'\tMime-TypeFilter Include:'+str(mimeTypeFilterInclusion)

	if not process:
		if debug:
			if not dateTimeFilterInclusion:
				workerItem.addTag('Rampiva|Filter|Date-Filter|Outside')
			if not mimeTypeFilterInclusion:
				workerItem.addTag('Rampiva|Filter|Mime-Type-Filter|Outside')
		else:
			workerItem.setProcessItem(False)
